document.addEventListener("DOMContentLoaded", function(){

addEvent();
setSkinFirst();
inputNumFirst();
save();

}); // DOMContentLoadedの終端

// イベントリスナーつけてまわるやつ
function addEvent(){
	res.addEventListener("change", changeList);
	now.addEventListener("change", changeList);
	log.addEventListener("change", changeList);
	next.addEventListener("click", nextMusic);
	skin.addEventListener("change", save);
	reset.addEventListener("click", resetStorage);
}

function setSkinFirst(){
	if(localStorage.setlista3Skin){
		let o = skin.querySelector("option[value='" + localStorage.setlista3Skin + "']");
		o.selected = true;
	}else{
		let o = skin.querySelector("option");
		o.selected = true;
	}
}

function inputNumFirst(){
	if(localStorage.setlista3Skin){
		res.value = localStorage.setlista3Res;
		now.value = localStorage.setlista3Now;
		log.value = localStorage.setlista3Log;
	}
}

function changeList(){
	res.value = tsumetsume(res.value);
	now.value = tsumetsume(now.value);
	log.value = tsumetsume(log.value);
	save();
}

function nextMusic(){
	if(now.value != ""){
		log.value += "\n" + now.value;
		now.value = "";
	}else{
		if(res.value != ""){
			let first = res.value.split("\n")[0];
			now.value = first;
			res.value = res.value.replace(first, "");
		}else{
		}
	}
	changeList();
}

function save(){
	localStorage.setlista3Res = res.value;
	localStorage.setlista3Now = now.value;
	localStorage.setlista3Log = log.value;
	localStorage.setlista3Skin = skin.value;
}

function resetStorage(){
		localStorage.clear();
		window.location.reload();
}

// 空白の行を詰める処理
function tsumetsume(txt){
	txt = txt.trim();
	txt = txt.replace(/(\r?\n)+/g,"\n");
	return txt;
}