document.addEventListener("DOMContentLoaded", function(){

checkListHeight();
checkSongWidth();

let style = document.createElement("style");
style.innerText = `
.scrollOut {
	animation: out 1s linear;
	animation-fill-mode: forwards;
}
@keyframes out {
	  0% { opacity: 1; }
	100% { opacity: 0; }
}

.scrollPop { animation: pop 0.5s linear; }
@keyframes pop {
	  0% { opacity: 0; }
	100% { opacity: 1; }
}
`;
document.body.appendChild(style);

}); // DOMContentLoadedの終端


function checkListHeight(){
	let sa = stlLog.scrollHeight - stlLog.clientHeight;
	if(sa > 0){
		scrollList(sa);
	}else{
		stlLog.scrollTo(0, 0);
		setTimeout(checkListHeight, 1000);
	}
}

function scrollList(v){
	stlLog.className = "scrollOut";
	setTimeout(function(){
		stlLog.scrollTo(0, 0);
		stlLog.className = "scrollPop";
	}, 1000);
	let i = 0;
	while(i < v){
		setTimeout(function(){
			stlLog.scrollBy(1, 1);
		}, (i * 40) + 4000);
		i++;
		if(i == v){
			setTimeout(checkListHeight, (i * 40) + 10000);
		}
	}
}

function checkSongWidth(){
	let sa = stlNow.scrollWidth - stlNow.clientWidth;
	if(sa > 0){
		scrollSong(sa);
	}else{
		stlNow.scrollTo(0, 0);
		setTimeout(checkSongWidth, 1000);
	}
}

function scrollSong(v){
	let i = 0;
	while(i < v){
		setTimeout(function(){
			stlNow.scrollBy(1, 1);
		}, (i * 20) + 4000);
		i++;
		if(i == v){
			setTimeout(function(){
				stlNow.className = "scrollOut";				
			}, (i * 20) + 6000);
			setTimeout(function(){
				stlNow.className = "scrollPop";				
				stlNow.scrollBy(-v, -v);
			}, (i * 20) + 7000);
			setTimeout(checkSongWidth, (i * 20) + 10000);
		}
	}
}
