document.addEventListener("DOMContentLoaded", function(){

addEvent();
setSkinFirst();
inputNumFirst();
save();

}); // DOMContentLoadedの終端

// イベントリスナーつけてまわるやつ
function addEvent(){
	res.addEventListener("change", changeList);
	now.addEventListener("change", changeList);
	log.addEventListener("change", changeList);
	next.addEventListener("click", nextMusic);
	skin.addEventListener("change", save);
	reset.addEventListener("click", resetStorage);

	window.addEventListener("storage", setTimeStamp);
	addTime.addEventListener("change", save);
}

function setSkinFirst(){
	if(localStorage.setlista3Skin){
		let o = skin.querySelector("option[value='" + localStorage.setlista3Skin + "']");
		o.selected = true;
	}else{
		let o = skin.querySelector("option");
		o.selected = true;
	}
}

function inputNumFirst(){
	if(localStorage.setlista3Skin){
		res.value = localStorage.setlista3Res;
		now.value = localStorage.setlista3Now;
		log.value = localStorage.setlista3Log;
		if(localStorage.setlista3addTime == "true"){
			addTime.checked = true;
		}
	}
}

function changeList(){
	res.value = tsumetsume(res.value);
	now.value = tsumetsume(now.value);
	log.value = tsumetsume(log.value);
	save();
}

function nextMusic(){
	if(now.value != ""){
		log.value += "\n" + now.value;
		now.value = "";
	}else{
		if(res.value != ""){
			let first = res.value.split("\n")[0];
			now.value = addTimeStamp(first);
			res.value = res.value.replace(first, "");
		}else{
		}
	}
	changeList();
}

function save(){
	localStorage.setlista3Res = res.value;
	localStorage.setlista3Now = now.value;
	localStorage.setlista3Log = log.value;
	localStorage.setlista3Skin = skin.value;
	localStorage.setlista3addTime = addTime.checked;
}

function resetStorage(){
		localStorage.clear();
		window.location.reload();
}

// 空白の行を詰める処理
function tsumetsume(txt){
	txt = txt.trim();
	txt = txt.replace(/(\r?\n)+/g,"\n");
	return txt;
}


let time = "0:00:00";
function setTimeStamp(){
	console.log(localStorage.setlista3Time);
	setInterval(function(){
		time = floorTime(new Date().getTime() - localStorage.setlista3Time);
		tsTime.innerHTML = time;
	}, 200);
	
	function floorTime(value){
		let hour = Math.floor(value/1000/60/60);
		let min = Math.floor(value/1000/60) % 60;
		let sec = Math.floor(value/1000) % 60;
		if(min < 10){ min = "0" + min; }
		if(sec < 10){ sec = "0" + sec; }
		return hour + ":" + min + ":" + sec;
	}
}

function addTimeStamp(text){
	if(addTime.checked){
		text += " - [ " + time + " ]";
	}
	return text;
}




